#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 300010

typedef struct {
    long long x, y;
    int id;
} Vec;

Vec vecs[MAXN];
int chosen[MAXN];
int n;

double compute_f(double theta) {
    double c = cos(theta);
    double s = sin(theta);
    double sum = 0.0;
    for (int i = 0; i < n; i++) {
        double proj = (double)vecs[i].x * c + (double)vecs[i].y * s;
        if (proj > 0.0) sum += proj;
    }
    return sum;
}

int cmp(const void* a, const void* b) {
    return (*(int*)a) - (*(int*)b);
}

int main() {
    scanf("%d", &n);
    for (int i = 0; i < n; i++) {
        scanf("%lld%lld", &vecs[i].x, &vecs[i].y);
        vecs[i].id = i + 1;
    }

    /* Ternarna pretraga po uglu [0, 2*PI) */
    double left = 0.0;
    double right = 2.0 * M_PI;
    for (int iter = 0; iter < 120; iter++) {  /* dovoljno precizno */
        double m1 = left + (right - left) / 3.0;
        double m2 = right - (right - left) / 3.0;
        double f1 = compute_f(m1);
        double f2 = compute_f(m2);
        if (f1 < f2) {
            left = m1;
        } else {
            right = m2;
        }
    }
    double best_theta = (left + right) / 2.0;

    /* Sada uzimamo sve vektore cija je projekcija >= 0 (sa malom tolerancijom) */
    double c = cos(best_theta);
    double s = sin(best_theta);
    int cnt = 0;
    for (int i = 0; i < n; i++) {
        double proj = (double)vecs[i].x * c + (double)vecs[i].y * s;
        if (proj >= -1e-9) {               /* tolerancija zbog plutajuce tacke */
            chosen[cnt++] = vecs[i].id;
        }
    }

    qsort(chosen, cnt, sizeof(int), cmp);

    printf("%d\n", cnt);
    for (int i = 0; i < cnt; i++) {
        if (i > 0) printf(" ");
        printf("%d", chosen[i]);
    }
    printf("\n");

    return 0;
}